/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import technology.rocketjump.undermount.environment.SunlightCalculator;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.WorldRenderer;
import technology.rocketjump.undermount.rendering.custom_libgdx.ShaderLoader;
import technology.rocketjump.undermount.rendering.lighting.AmbientLightingBatch;
import technology.rocketjump.undermount.rendering.lighting.LightRenderer;
import technology.rocketjump.undermount.rendering.lighting.PointLight;

@Singleton
public class WorldLightingRenderer
implements GameContextAware {
    private final LightRenderer lightRenderer;
    private final DebugWindow debugWindow;
    private final SunlightCalculator sunlightCalculator;
    private final AmbientLightingBatch outdoorLightingBatch;
    private final ShaderProgram outdoorShader;
    private GameContext gameContext;

    @Inject
    public WorldLightingRenderer(LightRenderer lightRenderer, DebugWindow debugWindow, SunlightCalculator sunlightCalculator) {
        this.lightRenderer = lightRenderer;
        this.debugWindow = debugWindow;
        this.sunlightCalculator = sunlightCalculator;
        FileHandle vertexShaderFile = Gdx.files.classpath("shaders/ambient_lighting_vertex_shader.glsl");
        FileHandle fragmentShaderFile = Gdx.files.classpath("shaders/ambient_lighting_fragment_shader.glsl");
        this.outdoorShader = ShaderLoader.createShader(vertexShaderFile, fragmentShaderFile);
        this.outdoorLightingBatch = new AmbientLightingBatch(2000, this.outdoorShader);
    }

    public void renderWorldLighting(TiledMap world, List<PointLight> lightList, OrthographicCamera camera, TextureRegion bumpMapTextureRegion) {
        Gdx.gl.glClearColor(0.25f, 0.25f, 0.32f, 1.0f);
        Gdx.gl.glClear(16384);
        Gdx.gl.glBlendEquation(32774);
        Gdx.gl.glBlendFunc(770, 771);
        Gdx.gl.glEnable(3042);
        this.renderOutdoorLighting(world, camera, bumpMapTextureRegion);
        this.lightRenderer.begin(bumpMapTextureRegion);
        for (PointLight pointLight : lightList) {
            this.lightRenderer.render(pointLight, camera);
        }
        this.lightRenderer.end();
        Gdx.gl.glBlendEquation(32774);
    }

    private void renderOutdoorLighting(TiledMap tiledMap, OrthographicCamera camera, TextureRegion bumpMapTextureRegion) {
        int minX = WorldRenderer.getMinX(camera);
        int maxX = WorldRenderer.getMaxX(camera, tiledMap);
        int minY = WorldRenderer.getMinY(camera);
        int maxY = WorldRenderer.getMaxY(camera, tiledMap);
        Color sunlightColor = Color.WHITE;
        if (this.gameContext != null) {
            sunlightColor = this.sunlightCalculator.getSunlightColor(this.gameContext.getGameClock().getGameTimeInHours());
        }
        tiledMap.getEnvironment().setSunlightAmount((sunlightColor.r + sunlightColor.g + sunlightColor.b) / 3.0f);
        this.outdoorLightingBatch.setColor(sunlightColor);
        this.outdoorLightingBatch.setProjectionMatrix(camera.combined);
        this.outdoorLightingBatch.begin();
        for (int worldY = maxY; worldY >= minY; --worldY) {
            for (int worldX = minX; worldX <= maxX; ++worldX) {
                MapVertex vertexNE;
                MapTile mapTile = tiledMap.getTile(worldX, worldY);
                if (mapTile == null || (vertexNE = tiledMap.getVertex(mapTile, CompassDirection.NORTH_EAST)) == null) continue;
                MapVertex vertexSW = tiledMap.getVertex(mapTile, CompassDirection.SOUTH_WEST);
                MapVertex vertexSE = tiledMap.getVertex(mapTile, CompassDirection.SOUTH_EAST);
                MapVertex vertexNW = tiledMap.getVertex(mapTile, CompassDirection.NORTH_WEST);
                this.outdoorLightingBatch.draw(mapTile.getTileX(), mapTile.getTileY(), 1.0f, 1.0f, vertexSW.getOutsideLightAmount(), vertexNW.getOutsideLightAmount(), vertexNE.getOutsideLightAmount(), vertexSE.getOutsideLightAmount());
            }
        }
        this.outdoorLightingBatch.end();
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

